---
generated_at: 2026-02-03 10:15:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：154-Cat ノード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.nodes.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/cat/RestNodesAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 行155
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行193

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIエンドポイントは GET /_cat/nodes | E-01, E-02 行98 | ○ |
| C-02 | 3段階連鎖リクエスト（ClusterState -> NodesInfo -> NodesStats） | E-02 行112-164 | ○ |
| C-03 | NodesInfoRequestのメトリクスはJVM, OS, PROCESS, HTTP | E-02 行129-135 | ○ |
| C-04 | NodesStatsRequestのメトリクスはindices, JVM, OS, FS, PROCESS, SCRIPT | E-02 行141-149 | ○ |
| C-05 | localパラメータは非推奨 | E-01, E-02 行93-94, 115-117 | ○ |
| C-06 | full_idパラメータでノードID完全表示 | E-02 行123 | ○ |
| C-07 | ディスク使用率はFsInfoから計算 | E-02 行465-476 | ○ |
| C-08 | ノードロールは略称と全名称の2カラム | E-02 行515-531 | ○ |
| C-09 | クラスタマネージャは*で表示 | E-02 行532 | ○ |
| C-10 | calculatePercentageメソッドでファイルディスクリプタ使用率計算 | E-02 行654-656 | ○ |
| C-11 | 関連機能No.49 ノード情報・統計 | E-04 | ○ |
| C-12 | リクエストパラメータにbytes, format, full_id等が存在 | E-01 params | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードとAPI仕様から直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 表示カラムの一覧がソースコードのgetTableWithHeader()と一致しているか
- [ ] 3段階連鎖リクエストの処理フローが正確か
- [ ] リクエストパラメータがcat.nodes.jsonの定義と一致しているか
